<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MainCompany extends Model 
{

    protected $table = 'maincompany';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('app_client_id');

    public function appClient()
    {
        return $this->belongsTo('App\Models\AppClient');
    }

    public function menus()
    {
        return $this->belongsToMany('App\Models\Menu');
    }

    public function roles()
    {
        return $this->hasMany('App\Models\Role');
    }

}